module.exports = function (bh) {

    /**
     * Находит решение в массиве решений по слагу
     * @param {String} slug
     * @param {Object []} solutions
     * @returns {Object}
     */
    function getSolution(slug, solutions) {
        return solutions.filter(function (solution) {
            return solution.slug === slug;
        })[0];
    }

    /* eslint-disable complexity */
    bh.match('solution-page-block', function (ctx, json) {
        var properties = json.properties;
        var gallery = properties.gallery;
        var solution = getSolution(properties.teaser, json.solutions);
        var url = solution && bh.lib.util.placeholder(
            '{s}/{s}/{s}',
            json.solutionsUrl,
            solution.section,
            solution.slug
        );
        var images = gallery.images;
        var cta = properties.cta;

        ctx.content([
            properties.title && {
                tag: 'h2',
                elem: 'title',
                content: properties.title
            },
            properties.text && {
                elem: 'text',
                mods: { type: properties.textType },
                mix: { block: 'html-content' },
                content: properties.text
            },
            images && images.length ? {
                elem: 'gallery',
                images: gallery.images,
                displayImage: gallery.displayImage
            } : null,
            cta && (cta.title || cta.description) && {
                elem: 'cta',
                content: {
                    block: 'product-features',
                    data: {
                        text: cta.description,
                        image: cta.image,
                        theme: cta.theme,
                        metrikaGoalId: cta.metrikaGoalId,
                        mobileImageReverse: true,
                        mobileButtonWide: true,
                        inlineCta: true,
                        isNarrowSection: false,
                        backgroundColor: 'grey',
                        alignImage: 'right',
                        textAlign: 'left',
                        textType: 'large',
                        cta: {
                            text: cta.buttonText,
                            url: cta.url
                        }
                    }
                }
            },
            solution && {
                elem: 'teaser',
                content: {
                    block: 'level',
                    mods: {
                        type: 'text2',
                        layout: 'page',
                        borders: 'yes'
                    },
                    level: {
                        textTitle: solution.title,
                        imageUrl: solution.image,
                        themeLink: { text: solution.theme },
                        imageType: 'icon',
                        enableButton: true,
                        url: url
                    }
                }
            }
        ]);
    });
    /* eslint-enable complexity */
};
