module.exports = function (bh) {
    bh.match('solutions-list', function (ctx, json) {
        var solutions = json.solutions;
        var url = json.solutionsUrl;

        ctx
            .js({
                solutionsCount: solutions.length,
                url: url,
                more: json.more,
                section: json.section,
                filterUrl: json.filterUrl
            })
            .content([
                {
                    elem: 'content',
                    solutions: solutions,
                    url: url
                },
                { block: 'notifications-list' },
                {
                    elem: 'gap',
                    mods: { disabled: 'yes' }
                }
            ]);
    });

    bh.match('solutions-list__content', function (ctx, json) {
        var solutions = json.solutions;

        ctx.content(solutions.map(function (solution) {
            var url = bh.lib.util.placeholder('{s}/{s}/{s}', json.url,
                solution.section, solution.slug);

            return {
                elem: 'item',
                solution: solution,
                url: url
            };
        }));
    });

    bh.match('solutions-list__item', function (ctx, json) {
        var solution = json.solution;
        var levelType = solution.levelType || 'text2';

        ctx.content({
            block: 'level',
            mods: { type: levelType },
            level: levelType === 'text2' ? {
                textTitle: solution.title,
                text: solution.preview,
                imageUrl: solution.image,
                imageType: solution.imageType,
                themeLink: { text: solution.theme },
                url: json.url,
                enableButton: true
            } : {
                text: solution.title,
                description: solution.preview,
                image: solution.image,
                button: {
                    enabled: solution.buttonEnabled,
                    text: bh.lib.i18n('solutions', 'read.more'),
                    link: json.url
                }
            }
        });
    });

    bh.match('solutions-list__cover', function (ctx) {
        ctx.content({
            block: 'spin2',
            mods: {
                size: 'l',
                progress: 'yes'
            }
        });
    });
};
