BEM.DOM.decl('solutions-list', {
    onSetMod: {
        js: {
            inited: function () {
                this._initialize();

                this.solutionsCount = this.params.solutionsCount;

                this.bindToWin('scroll', this._onScroll.bind(this));
            }
        }
    },

    /**
     * Инициализация блока
     * @private
     */
    _initialize: function () {
        this.__self.list = this;
        this.content = this.findElem('content');
        this._gap = this.findElem('gap');
        this.more = this.params.more;
        this._chunkLength = 8;
        this._isServerFree = true;
        this._lockSpinnerMore = false;
    },

    /**
     * Заменяет старые решения на новые
     * @param {Object} data
     * @private
     */
    setSolutions: function (data) {
        this._isServerFree = true;

        if (data && Array.isArray(data.list)) {
            this._destructSolutions();
            this._appendSolutions(data.list);
        } else {
            this._showErrorMessage();
        }
    },

    /**
     * Добавляет переданные решения в список
     * @param {Object []} solutions
     * @private
     */
    _appendSolutions: function (solutions) {
        var solutionsBlock = solutions
            .reduce(function (current, solution) {
                var url = BH.lib.util.placeholder('{s}/{s}/{s}', this.params.url,
                    solution.section, solution.slug);

                return current + BH.apply({
                    block: 'solutions-list',
                    elem: 'item',
                    solution: solution,
                    url: url
                });
            }.bind(this), '');

        BEM.DOM.append(this.content, solutionsBlock);

        this.solutionsCount += solutions.length;
    },

    /**
     * Удаляет все решения из списка
     * @private
     */
    _destructSolutions: function () {
        this.content.text('');
        this.solutionsCount = 0;
    },

    /**
     * Обработчик скролла
     * @private
     */
    _onScroll: function () {
        var windowOffset = window.pageYOffset + window.innerHeight;
        var contentOffset = this.content.offset().top + this.content.height();
        var areManySolutions = this.solutionsCount >= this._chunkLength;

        if (this.more && areManySolutions && windowOffset > contentOffset) {
            this._runSpinnerMore();
            this._loadSolutionsChunk();
        }
    },

    /**
     * Загружает с сервера новый набор решений
     * @private
     */
    _loadSolutionsChunk: function () {
        if (!this._isServerFree) {
            return;
        }

        this._isServerFree = false;

        var filter = BEM.blocks['level-solution'].getFilter();

        var requestOptions = {
            type: 'POST',
            url: this.params.filterUrl,
            contentType: 'application/json',
            data: JSON.stringify({
                startIdx: this.solutionsCount,
                section: this.params.section,
                filter: filter && {
                    by: filter.by,
                    value: filter.value
                }
            })
        };

        $.ajax(requestOptions)
            .done(this._resetSolutions.bind(this))
            .fail(this._showErrorMessage.bind(this));
    },

    /**
     * Показывает спиннер при подгрузке новых решений
     */
    _runSpinnerMore: function () {
        if (this._lockSpinnerMore) {
            return;
        }

        this._lockSpinnerMore = true;

        this.delMod(this._gap, 'disabled');

        var spinner = BH.apply({
            block: 'solutions-list',
            elem: 'cover',
            mods: { type: 'more' }
        });

        this._spinnerMore = $(spinner);

        BEM.DOM.append(this._gap, this._spinnerMore);
    },

    /**
     * Скрывает спиннер для подгрузки новых решений
     * @private
     */
    _hideSpinnerMore: function () {
        if (!this._spinnerMore) {
            return;
        }

        this._lockSpinnerMore = false;

        this.setMod(this._gap, 'disabled', 'yes');

        BEM.DOM.destruct(this._spinnerMore);
    },

    /**
     * Обработчик ответа сервера
     * @param {Object} data
     * @returns {null}
     * @private
     */
    _resetSolutions: function (data) {
        this._isServerFree = true;

        if (!data || !Array.isArray(data.list)) {
            return this._showErrorMessage();
        }

        this.more = data.more;

        this._appendSolutions(data.list);
        this._hideSpinnerMore();
    },

    /**
     * Показывает сообщение об ошибке
     * @private
     */
    _showErrorMessage: function () {
        this._isServerFree = true;
        this._hideSpinnerMore();

        var failMessage = BH.lib.i18n('solutions', 'error');

        BEM.blocks['notifications-list'].notify(failMessage);
    }
}, {

    /**
     * Показывает спиннер
     */
    runSpinner: function () {
        var spinner = BH.apply({
            block: 'solutions-list',
            elem: 'cover',
            mods: {
                type: this.list.solutionsCount === 0 && 'more'
            }
        });

        this.list.spinner = $(spinner);

        BEM.DOM.append(this.list.content, this.list.spinner);
    },

    /**
     * Скрывает спиннер
     */
    hideSpinner: function () {
        if (this.list.spinner) {
            BEM.DOM.destruct(this.list.spinner);
        }
    },

    /**
     * Заменяет старые решения на переданные
     * @param {Object} data
     * @returns {Object}
     */
    setSolutions: function (data) {
        this.list.more = data.more;
        this.prototype.setSolutions.call(this.list, data);

        return this;
    }
});
