module.exports = function (bh) {
    'use strict';
    bh.match('subscription', function (ctx, json) {
        var data = json.subscription;
        var mode = data.maillist ? 'single' : 'multi';

        ctx.content([
            {
                elem: 'head-description',
                content: data.headDescription
            },
            {
                block: 'contact-form',
                js: {
                    subscriptionType: json.subscriptionType,
                    url: bh.lib.global.subscribeFormPath,
                    metrikaGoalId: 'form_subscription_' + json.subscriptionType,
                    formName: 'subscription-form'
                },
                fields: data.fields,
                agreements: data.agreements,
                button: {
                    text: bh.lib.i18n('forms', 'subscription.button'),
                    align: 'center'
                },
                successTitle: bh.lib.i18n('forms', 'subscribed.' + mode + '.title'),
                successText: bh.lib.i18n('forms', 'subscribed.' + mode + '.text')
            },
            {
                elem: 'description',
                content: data.description
            }
        ]);
    });

    bh.match('subscription__description', function (ctx) {
        ctx.mix({ block: 'html-content' });
    });
};
