module.exports = function (bh) {
    bh.match('support-contacts', function (ctx, json) {
        ctx
            .tag('section')
            .mod('expanded', 'yes');

        if (!json.contacts) {
            return ctx.content(ctx.content());
        }

        ctx.content([
            {
                elem: 'list',
                content: json.contacts.map(function (contact) {
                    return {
                        elem: 'item',
                        content: [
                            {
                                elem: 'region',
                                content: contact.title
                            },
                            {
                                elem: 'phone',
                                content: contact.phone
                            }
                        ]
                    };
                })
            },
            {
                elem: 'link',
                form: json.form
            }
        ]);
    });

    bh.match('support-contacts__item', function (ctx) {
        ctx.mix([
            { block: 'clearfix' }
        ]);
    });

    bh.match('support-contacts__link', function (ctx) {
        var form = ctx.param('form');

        if (form.url) {
            ctx.content([
                {
                    block: 'link',
                    url: form.url,
                    content: bh.lib.i18n('support', 'feedback.link')
                }
            ]);
        } else {
            ctx.content([
                {
                    elem: 'trigger',
                    tag: 'span',
                    content: [
                        bh.lib.i18n('support', 'feedback.form'),
                        {
                            block: 'icon',
                            mods: {
                                type: 'arrow',
                                direction: 'top'
                            }
                        }
                    ]
                }
            ]);
        }

        if (form.type === 'form') {
            return [
                ctx.json(),
                {
                    elem: 'form',
                    formId: form.form
                }
            ];
        }
    });

    bh.match('support-contacts__form', function (ctx) {
        ctx.content({
            elem: 'iframe',
            formId: ctx.param('formId')
        });
    });

    bh.match('support-contacts__iframe', function (ctx) {
        var formId = ctx.param('formId');

        ctx.content({
            block: 'iframe-form',
            formId: formId
        });
    });
};
