var LABEL_KEYS = ['days', 'hours', 'minutes', 'seconds'];

module.exports = function (bh) {
    bh.match('timer', function (ctx) {
        function constructTimerBlock(elem, id) {
            return [
                {
                    elem: 'block',
                    content: [
                        {
                            elem: elem,
                            mix: { elem: 'time' },
                            content: '00'
                        },
                        {
                            elem: 'title',
                            content: bh.lib.i18n('common', elem)
                        }
                    ]
                },
                id < 3 && {
                    elem: 'block-sep',
                    content: ':'
                }
            ];
        }

        ctx.content(LABEL_KEYS.map(constructTimerBlock));
    });
};
