BEM.DOM.decl('timer', {
    onSetMod: {
        js: {
            inited: function () {
                this._labels = {
                    days: this.findElem('days'),
                    hours: this.findElem('hours'),
                    minutes: this.findElem('minutes'),
                    seconds: this.findElem('seconds')
                };
                this._initializeTimer(this.params.endTime);
            }
        }
    },

    _getRemainingTime: function (endTime) {
        var diff = Math.max(Date.parse(endTime) - Date.now(), 0);

        var seconds = Math.floor((diff / 1000) % 60);
        var minutes = Math.floor((diff / 1000 / 60) % 60);
        var hours = Math.floor((diff / (1000 * 60 * 60)) % 24);
        var days = Math.floor(diff / (1000 * 60 * 60 * 24));

        var timeObject = {
            total: diff,
            days: days,
            hours: hours,
            minutes: minutes,
            seconds: seconds
        };

        Object.keys(timeObject).forEach(function (key) {
            timeObject[key] = ('0' + timeObject[key]).slice(-2);
        });

        return timeObject;
    },

    _initializeTimer: function (endTime) {
        setInterval(function () {
            var remainingTime = this._getRemainingTime(endTime);

            Object.keys(this._labels)
                .forEach(function (key) {
                    this._labels[key].text(remainingTime[key]);
                }.bind(this));
        }.bind(this), 1000);
    }
});
