BEM.DOM.decl('top-menu', {

    onSetMod: {
        js: {
            inited: function () {
                this._headerHeight = this.domElem.offset().top;
                this._openedItem = null;

                this._placeTopMenu.apply(this);

                this.bindEvents();
            }
        }
    },

    bindEvents: function () {
        this.bindToWin('pointerclick', this._closeDropdown.bind(this));
        this.bindToWin('scroll', this._closeDropdown.bind(this));

        this.bindTo('item', 'pointerclick', this._onMenuItemClick.bind(this));
        this.bindTo('submenu', 'pointerclick', function (e) {
            e.stopPropagation();
        });
    },

    _placeTopMenu: function () {
        this._closeDropdown();
    },

    _onMenuItemClick: function (e) {
        e.stopPropagation();

        var domElem = $(e.data.domElem);
        var alreadyOpened = this.hasMod(domElem, 'collapsed');

        this._closeDropdown();

        if (!alreadyOpened) {
            this._openDropdown(domElem);
        }
    },

    _openDropdown: function (domElem) {
        this.setMod(domElem, 'collapsed', 'yes');
        this._openedItem = domElem;
    },

    _closeDropdown: function () {
        if (!this._openedItem) {
            return;
        }

        this.delMod(this._openedItem, 'collapsed');
    }
});
