module.exports = function (bh) {
    bh.match('user__enter', function () {
        var title = bh.lib.i18n('user', 'enter');
        var authUrl = bh.lib.util.passport.getUrl();

        return [
            {
                block: 'button',
                mods: { size: 's', theme: 'clear' },
                mix: [{ block: 'user', elem: 'enter' }],
                url: authUrl,
                attrs: {
                    tabindex: '-1',
                    title: title,
                    'aria-label': title
                },
                content: [
                    {
                        block: 'user',
                        elem: 'enter-label'
                    }
                ]
            }
        ];
    });
};
