/* eslint-disable no-undef */
BEM.DOM.decl('wysiwyg', {
    onSetMod: {
        js: {
            inited: function () {
                this.initEditor(this.domElem, this.params);
            }
        }
    },
    initEditor: function (element, options) {
        if (!MediumEditor) {
            options.onErrorInit('Fail on load MediumEditor');

            return;
        }

        if (!element) {
            options.onErrorInit('Fail on load MediumEditor');

            return;
        }

        this._textarea = element;

        // Нужно считывать до инициализации, иначе будет 0
        var textareaHeight = this._textarea[0].clientHeight;

        var DEFAULT_PARAMS = {
            placeholder: {
                text: options.placeholder
            },
            anchor: {
                customClassOption: null,
                linkValidation: true,
                placeholderText: options.anchorPlaceholder
            },
            fileDragging: {
                allowedTypes: []
            }
        };
        var mediumParams = $.extend(DEFAULT_PARAMS, options.params || {});

        this._editor = new MediumEditor(this._textarea, mediumParams);
        this._editorDOM = this._editor.elements[0];

        this._editorDOM.style.minHeight = textareaHeight + 'px';

        this._editor.subscribe('editableInput', function () {
            this.domElem.trigger('change');
        }.bind(this));

        this._editor.subscribe('editableKeydown', function (e) {
            this.domElem.trigger('keydown', e);
        }.bind(this));

        options.onSuccessInit(this);
    },

    /**
     * Устанавливает значение wysiwyg в val
     * @param {String} val
     */
    setValue: function (val) {
        this._editorDOM.innerHTML = val;
        this._textarea.value = val;

        if (!this.isReadOnly()) {
            this.domElem.trigger('change');
        }
    },

    /**
     * Возвращает текущее значение wysiwyg
     * @param {Boolean} plain текст или html с тэгами
     * @returns {String}
     */
    getValue: function (plain) {
        return plain ? this._editorDOM.innerText : this._editorDOM.innerHTML;
    },

    /**
     * Возвращает статус активности WYSIWYG
     * @returns {boolean}
     */
    isReadOnly: function () {
        return this._editorDOM.getAttribute('contenteditable') === 'false';
    },

    /**
     * Активирует возможность редактирования
     */
    enable: function () {
        this._editorDOM.setAttribute('contenteditable', 'true');
    },

    /**
     * Деактивирует возможность редактирования
     */
    disable: function () {
        this._editorDOM.setAttribute('contenteditable', 'false');
    }
}, {

});
