BEM.DOM.decl('ya-cmnt', {
    onSetMod: {
        js: {
            inited: function () {
                this._commentsData = this.params.commentsData;
                this._reactScript = this.params.reactScript;

                this._initComments();
                this._scrollToComments();
            }
        }
    },

    _initComments: function () {
        window.Ya = window.Ya || {};
        window.Ya.Cmnt = {
            theme: 'mg',
            lang: this._commentsData.lang,
            service: 'vda'
        };

        this._addScript(
            this._reactScript,
            this._onLoadReactScript.bind(this),
            this._onLoadError
        );
    },

    _addScript: function (src, onLoadCb, onErrorCb) {
        var script = document.createElement('script');

        script.type = 'text/javascript';
        script.setAttribute('crossorigin', 'anonymous');
        script.src = src;

        script.onload = onLoadCb;
        script.onerror = onErrorCb;

        document.body.appendChild(script);
    },

    _scrollToComments: function () {
        if (this._commentsData.shouldScrollToComments) {
            BEM.blocks['scroll-to'].scrollTo(this, { offsetTop: 70 });
        }
    },

    _onLoadReactScript: function () {
        this._addScript(
            this._commentsData.loader,
            this._onLoadCmntScript.bind(this),
            this._onLoadError
        );
    },

    _onLoadCmntScript: function () {
        var params = {
            apiKey: this._commentsData.apiKey,
            entityId: this._commentsData.entityId,
            tld: this._commentsData.tld,
            isMobile: this.params.isMobile,
            features: {
                reactions: {
                    tap: {
                        reaction: false,
                        popup: true
                    },
                    longtap: {
                        popup: true
                    }
                }
            }
        };

        if (this._commentsData.commentId) {
            params.commentId = this._commentsData.commentId;
        }

        if (this._commentsData.officialToken) {
            params.features.officiality = { token: this._commentsData.officialToken };
        }

        window.Ya.Cmnt.init(this.params.containerId, params);
    },

    _onLoadError: function () {
        var failLoadMessage = BH.lib.util.errors.getCommentsErrorText('get');

        BEM.blocks['notifications-list'].notify(failLoadMessage);
    }
});
