module.exports = function (bh) {
    bh.match('dashboard__filter-group', function (ctx, json) {
        var options = json.options;
        var dashboard = json.dashboard;
        var comparison = json.comparison;
        var currentTree = json.tree;
        var addCompare = Boolean(json.addCompare);

        ctx
            .mod('comparison', comparison ? 'yes' : 'no')
            .content([
                {
                    elem: 'group-column',
                    mods: { name: 'add-compare' },
                    comparison: comparison,
                    addCompare: addCompare
                },
                {
                    elem: 'group-column',
                    mods: { responsive: 'yes', name: 'category' },
                    comparison: comparison,
                    currentTree: currentTree,
                    options: options,
                    categories: dashboard.categories
                },
                {
                    elem: 'group-column',
                    mods: { responsive: 'yes', name: 'type' },
                    comparison: comparison,
                    currentTree: currentTree,
                    options: options
                },
                {
                    elem: 'group-column',
                    mods: { responsive: 'yes', name: 'region' },
                    comparison: comparison,
                    options: options,
                    currentTree: currentTree,
                    regions: dashboard.regions
                },
                {
                    elem: 'group-column',
                    mods: { name: 'platform' },
                    comparison: comparison,
                    currentTree: currentTree,
                    options: options
                },
                {
                    elem: 'group-column',
                    content: !comparison && {
                        elem: 'help-button'
                    }
                }
            ]);
    });

    bh.match('dashboard__group-column_name_add-compare', function (ctx, json) {
        var comparison = json.comparison;
        var addCompare = json.addCompare;

        ctx
            .content({
                block: 'button2',
                title: bh.lib.i18n('dashboard', comparison ? 'title.remove' : 'title.add'),
                mods: {
                    theme: 'pseudo',
                    size: 'm',
                    type: comparison ? 'delete' : 'add',
                    hidden: addCompare ? 'no' : 'yes'
                },

                text: comparison ? '-' : '+'
            });
    });
};
