module.exports = function (bh) {
    bh.match('expert-page', function (ctx, json) {
        var expert = json.expert;

        ctx
            .mix({ block: 'page-content' })
            .content(expert.feedbackForm && {
                block: 'modal',
                mods: {
                    theme: 'normal',
                    autoclosable: 'yes',
                    type: 'basic',
                    size: 'm',
                    'freelancers-form': 'feedback'
                },
                content: {
                    block: 'iframe-form',
                    formId: 8500,
                    params: {
                        freelancer: expert.name
                    }
                }
            });
    });

    bh.match('expert-page__left', function (ctx, json) {
        var expert = json.expert;
        var eduExpert = json.eduExpert;
        var certByYandex = json.certByYandex;

        ctx.content([
            {
                elem: 'image',
                imageUrl: expert.bigPhoto
            },
            eduExpert && {
                elem: 'plate',
                eduExpert: eduExpert,
                certByYandex: certByYandex
            },
            {
                elem: 'certificates',
                certificates: expert.certificates,
                verificationUrl: expert.verificationUrl
            },
            {
                elem: 'text',
                expert: expert
            },
            {
                block: 'solution-info',
                elem: 'info-brief',
                info: json.info
            },
            expert.contactFormButton && {
                elem: 'contact-button',
                linkForConnect: expert.linkForConnect
            }
        ]);
    });

    bh.match('expert-page__right', function (ctx, json) {
        var expert = json.expert;
        var filters = json.filters;
        var workFormats = expert.workFormats;
        var events = json.events;
        var reviews = expert.reviews;
        var searchUrl = json.searchUrl;

        ctx.content([
            {
                elem: 'name',
                content: expert.name
            },
            {
                elem: 'description',
                content: expert.description
            },
            filters && filters.length ? filters.map(function (filter) {
                return {
                    elem: 'filter',
                    data: filter,
                    searchUrl: searchUrl
                };
            }) : null,
            {
                elem: 'specializations',
                specializations: expert.specializations,
                searchUrl: searchUrl
            },
            {
                elem: 'work-formats',
                workFormats: workFormats,
                searchUrl: searchUrl
            },
            {
                elem: 'events',
                events: events,
                eventSlugToUrl: json.eventSlugToUrl,
                expertSlugToName: json.expertSlugToName
            },
            {
                elem: 'reviews',
                reviews: reviews
            },
            expert.feedbackForm && { elem: 'feedback-button' }
        ]);
    });

    bh.match('expert-page__feedback-button', function (ctx) {
        ctx.content({
            block: 'button2',
            mods: { theme: 'normal', size: 'm' },
            text: bh.lib.i18n('edu', 'leave.feedback')
        });
    });
};
