module.exports = function (bh) {
    bh.match('head', function (ctx, json) {
        var levels = bh.lib.getHeaderMenu(bh.lib.global.tld) || [];

        ctx
            .mod('opened', 'no')
            .tag('header')
            .content([
                {
                    elem: 'line-wrap',
                    content: [
                        {
                            elem: 'current-line',
                            content: [
                                {
                                    elem: 'logo',
                                    url: json.mordaHost
                                },
                                {
                                    elem: 'menu',
                                    levels: levels
                                },
                                {
                                    elem: 'right-column',
                                    content: [
                                        {
                                            block: 'user',
                                            mods: {
                                                menu: 'multiauth',
                                                adv: 'yes'
                                            },
                                            content: { elem: 'name' }
                                        },
                                        (levels.length > 1) && {
                                            elem: 'menu-button'
                                        }
                                    ]
                                },
                                {
                                    elem: 'paranja'
                                }
                            ]
                        }
                    ]
                }
            ]);
    });

    bh.match('head__menu', function (ctx, json) {
        var levels = json.levels;

        var content = levels.map(function (services, idx) {
            var isCurrentLevel = false;
            var links = services.map(function (service) {
                if (service.current) {
                    isCurrentLevel = true;
                }

                return {
                    elem: 'link',
                    current: service.current,
                    url: service.url,
                    name: service.name
                };
            });

            return {
                elem: 'menu-level',
                mods: { pos: levels.length - idx - 1 },
                services: links,
                current: isCurrentLevel
            };
        });

        ctx.content(content.reverse());
    });

    bh.match('head__menu-level', function (ctx, json) {
        if (json.current) {
            ctx.mod('current', true);
        }

        ctx.content(json.services);
    });

    bh.match('head__link', function (ctx, json) {
        var url = json.url || '';

        if (json.current) {
            ctx.mod('current', true);
        }

        if (url) {
            ctx.tag('a');
            ctx.attr('href', url);
        } else {
            ctx.tag('span');
        }

        ctx.content(json.name);
    });

    bh.match('head__user', function (ctx, json) {
        var login = json.login;
        var name = json.name;

        ctx.tag('span');

        ctx.content([
            login && {
                elem: 'username',
                name: name || login
            }
        ]);
    });

    bh.match('head__username', function (ctx, json) {
        ctx.tag('span');
        ctx.content(json.name);
    });
};
