module.exports = function (blocks, blockName) {
    'use strict';

    blocks.declare(blockName, function () {
        var data = require('./horizontal-select.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'gemini-resizer',
                    mods: { type: 'few' },
                    attrs: { style: 'background-color: #31334a;' },

                    content: {
                        block: 'horizontal-select',
                        data: {
                            items: data.options
                        }
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { type: 'many' },
                    attrs: { style: 'background-color: #31334a; padding: 0 300px;' },

                    content: {
                        block: 'horizontal-select',
                        data: {
                            items: data.manyOptions
                        }
                    }
                }
            ]
        };
    });
};
