BEM.DOM.decl('horizontal-select', {
    onSetMod: {
        js: {
            inited: function () {
                this.__base.apply(this, arguments);

                this.bindTo(this._itemWrapper, 'keyup', this._onKeyUp.bind(this));

                this.bindTo(this.domElem, 'mousedown', this._onMousePressDown.bind(this));
                this.bindTo(this.domElem, 'mouseup', this._onMousePressUp.bind(this));
                this.bindTo(this.domElem, 'mousemove', this._onMouseMove.bind(this));
                this.bindTo(this.domElem, 'mouseout', this._onMouseOut.bind(this));
            }
        }
    },

    _onKeyUp: function(event) {
        var enterKeyCode = 13;

        if (event.keyCode === enterKeyCode) {
            this.select(event.target);
        }
    },

    _onMousePressDown: function(event) {
        this._dragStart(event.clientX);
    },

    _onMouseMove: function(event) {
        this._drag(event.clientX);
    },

    _onMousePressUp: function(event) {
        this._dragEnd(event);
    },

    _onMouseOut: function(event) {
        this._cancelScrolling(event);
    },

    _calcScrollOffset: function(position, width) {
        var additionalOffset = 60;

        return position.left < 0 ?
            (position.left - additionalOffset) :
            (Math.abs(position.right - width) + additionalOffset);
    }
});
