module.exports = function (bh) {
    bh.match('lesson-navigation', function (ctx, json) {
        var data = json.data;
        var prev = data.prev;
        var next = data.next;
        var listLink = data.listLink;

        var prevLesson = bh.lib.i18n('edu', 'prev.lesson');
        var nextLesson = bh.lib.i18n('edu', 'next.lesson');

        ctx.content([
            prev && {
                elem: 'nav',
                mods: { prev: true },
                content: {
                    block: 'link',
                    mods: { theme: 'normal' },
                    url: bh.lib.util.placeholder('{s}/{s}', listLink, prev.slug),
                    text: bh.lib.util.placeholder('←{s}', prevLesson)
                }
            },
            {
                elem: 'nav',
                content: {
                    block: 'link',
                    mods: { theme: 'normal' },
                    url: listLink,
                    text: bh.lib.i18n('edu', 'lessons.list')
                }
            },
            next && {
                elem: 'nav',
                mods: { next: true },
                content: {
                    block: 'link',
                    mods: { theme: 'normal' },
                    url: bh.lib.util.placeholder('{s}/{s}', listLink, next.slug),
                    text: bh.lib.util.placeholder('{s}→', nextLesson)
                }
            }
        ]);
    });
};
