module.exports = function (bh) {
    'use strict';

    bh.match('level-image2', function (ctx, json) {
        var level = json.level;
        var image = bh.lib.util.mds(json.level.image, 'mainpage_image_d');

        ctx
            .mods({
                font: level.black && 'dark',
                background: image && 'image'
            })
            .attrs({
                style: image && 'background-image: url("' + image + '");'
            })
            .content({
                elem: 'content',
                content: [
                    {
                        elem: 'title',
                        content: level.text
                    },
                    !level.isSeparatedText && {
                        elem: 'description',
                        content: level.description
                    }
                ]
            });
    });
};
