module.exports = function (bh) {
    'use strict';
    bh.match('level__video', function (ctx, json) {
        if (!json.video) {
            return;
        }

        ctx.content([
            {
                elem: 'video-close'
            },
            {
                elem: 'video-iframe',
                video: json.video
            },
            json.info && {
                elem: 'video-info',
                content: json.info
            }
        ]);
    });

    bh.match('level__video-iframe', function (ctx, json) {
        ctx.content({
            tag: 'iframe',
            attrs: {
                width: 640,
                height: 360,
                frameborder: 0,
                allowfullscreen: true,
                src: json.video
            }
        });
    });
};
