module.exports = function (bh) {
    /* eslint-disable complexity */
    bh.match('level_type_help', function (ctx, json) {
        var items = json.level.items;

        if (!items || !items.length) {
            return '';
        }

        ctx.content([
            {
                elem: 'help-column',
                mods: { logo: true },
                content: [
                    { elem: 'logo' },
                    items[4] && {
                        elem: 'item',
                        mods: { bottom: true },
                        item: items[4]
                    }
                ]
            },
            {
                elem: 'help-column',
                content: [
                    {
                        elem: 'item',
                        item: items[0]
                    },
                    items[2] && {
                        elem: 'item',
                        mods: { bottom: true },
                        item: items[2]
                    }
                ]
            },
            items.length > 1 && {
                elem: 'help-column',
                content: [
                    {
                        elem: 'item',
                        item: items[1]
                    },
                    (items[3] || items[2]) && {
                        elem: 'item',
                        mods: { bottom: true },
                        item: items[3]
                    }
                ]
            }
        ]);
    });
    /* eslint-enable complexity */
};
