module.exports = function (bh) {
    'use strict';
    bh.match('level_type_journal', function (ctx, json) {
        var image = json.level.image;
        var imageUrl = json.level.lowQuality ? bh.lib.util.mds(image, 'mainpage_journal_d') : image;

        ctx.tParam('mdsImage', imageUrl);
    });

    bh.match('level__content_type_journal', function (ctx, json) {
        ctx.content(json.columns.map(function (column) {
            return {
                elem: 'column',
                content: column
            };
        }));
    });

    bh.match('level__not-supported', function (ctx) {
        ctx.content([
            { elem: 'not-supported-description' },
            { elem: 'not-supported-image' }
        ]);
    });
};
