module.exports = function (bh) {

    bh.match('level_type_showcase__product', function (ctx, data) {
        var product = data.product;

        if (!product) {
            return '';
        }

        ctx
            .tag('a')
            .attrs({ href: product.url })
            .js({ metrikaGoalId: product.metrikaGoalId })
            .content(
                [
                    product.title && {
                        tag: 'h4',
                        elem: 'product-title',
                        content: product.title
                    },
                    product.text && {
                        elem: 'product-text',
                        content: product.text
                    }
                ]
            );
    });

    bh.match('level_type_showcase__cta', function (ctx, data) {
        var cta = data.cta;

        if (!cta) {
            return '';
        }

        ctx.content(
            [
                cta.title && {
                    tag: 'h4',
                    elem: 'cta-title',
                    content: cta.title
                },
                cta.buttonText && {
                    block: 'button2',
                    mods: { size: 'm', theme: 'action', type: 'link', cta: true },
                    url: cta.url,
                    text: cta.buttonText
                }
            ]
        );
    });
};

