module.exports = function (bh) {
    bh.match('level__right', function (ctx, json) {
        var themeLink = json.themeLink;
        var text = themeLink && themeLink.text;

        ctx.content([
            text && {
                elem: 'theme',
                themeLink: themeLink
            }
        ]);
    });

    bh.match('level__img', function (ctx, json) {
        var src = json.imageType === 'image' ?
            bh.lib.util.mds(json.imageUrl, 'mainpage_text_large_d_2x') :
            json.imageUrl;

        ctx.attrs({
            src: src
        });
    });
};
