BEM.DOM.decl({ block: 'level', modName: 'type', modVal: 'video' }, {
    onSetMod: {
        js: function () {
            this._links = this.findBlocksInside('level-card');
            this._modal = this.findBlockInside('modal');
            this._closeButtonSelector = BEM.blocks['i-bem'].buildSelector('level', 'video-close');

            this._links.map(this._bindToLinks.bind(this));

            // В леговском компоненте modal баг с модификатором autoclosable:
            // Закроем видео по крестику и повторно его откроем.
            // Закрыть по клику вне модального окна получится только со второго раза.
            // Поэтому вручную обрабатываем клик по модалке - если нажали не на видео, то закрываем
            this._modal.elem('cell').on('pointerclick', this._tryCloseModal.bind(this));

            this._modal.on('afterClose', this._destroyModalData.bind(this));
        }
    },

    _bindToLinks: function (card) {
        this.bindTo(card.elem('link'), 'pointerclick', this._openModal.bind(this, card));
    },

    _tryCloseModal: function(event) {
        if (event.target.classList.contains('modal__cell')) {
            this._modal.delMod('visible');
        }
    },

    _destroyModalData: function () {
        this._modal.setContent('');
    },

    _openModal: function (card, event) {
        var videoUrl = card.domElem.attr('data-video');
        var info = card.domElem.attr('data-info');

        this._modal.setContent(BH.apply({
            block: 'level',
            elem: 'video',
            video: videoUrl,
            info: info
        }));

        var $closeButton = this._modal.domElem.find(this._closeButtonSelector);

        $closeButton.one('pointerclick', function () {
            this._modal.delMod('visible');
        }.bind(this));

        this._modal.setMod('visible', 'yes');

        event.preventDefault();

        return false;
    }
});
