BEM.DOM.decl({ block: 'level', modName: 'type', modVal: 'video2' }, {
    onSetMod: {
        js: function () {
            this._levelCard = this.findBlockInside('level-card');

            this._modal = this.findBlockInside('modal');
            this._closeButtonSelector = BEM.blocks['i-bem'].buildSelector('level', 'video-close');

            this.bindTo(this._levelCard.elem('link'), 'pointerclick', this._openModal.bind(this));
            this.bindTo(this.findElem('title'), 'pointerclick', this._openModal.bind(this));
            this._modal.on('afterClose', this._destroyModalData.bind(this));
        }
    },

    _destroyModalData: function () {
        this._modal.setContent('');
    },

    _openModal: function (event) {
        var videoUrl = this._levelCard.domElem.attr('data-video');
        var info = this._levelCard.domElem.attr('data-info');

        this._modal.setContent(BH.apply({
            block: 'level',
            elem: 'video',
            video: videoUrl,
            info: info
        }));

        var $closeButton = this._modal.domElem.find(this._closeButtonSelector);

        $closeButton.one('pointerclick', function () {
            this._modal.delMod('visible');
        }.bind(this));

        this._modal.setMod('visible', 'yes');

        event.preventDefault();

        return false;
    }
});
