module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./main-layout-nock.json');

        var product = data.product;
        var sections = data.sections;

        return {
            block: blockName,
            content: [
                {
                    block: 'main-layout',
                    mods: { 'sticky-left': 'yes', test: 'plain' },
                    right: {
                        block: 'page-content',
                        content: [
                            {
                                elem: 'title',
                                content: product.title
                            },
                            product.text && {
                                elem: 'text',
                                mix: { block: 'html-content' },
                                image: product.image,
                                imageAlign: product.imageAlign,
                                text: product.text
                            },
                            sections
                        ]
                    }
                },
                {
                    block: 'main-layout',
                    mods: { 'sticky-left': 'yes' },
                    right: {
                        block: 'page-content',
                        content: [
                            product.text && {
                                elem: 'text',
                                mix: { block: 'html-content' },
                                mods: { test: 'full-width' },
                                image: product.image,
                                imageAlign: 'full-width',
                                text: product.text
                            },
                            {
                                block: 'gemini-resizer',
                                attrs: { style: 'margin-bottom: 40px' },
                                content: [
                                    product.text && {
                                        block: 'page-content',
                                        elem: 'text',
                                        mix: [{ block: 'html-content' }, { block: 'clearfix' }],
                                        mods: { test: 'left' },
                                        image: product.image,
                                        imageAlign: 'left',
                                        text: product.text
                                    }
                                ]
                            },
                            product.text && {
                                elem: 'text',
                                mix: { block: 'html-content' },
                                mods: { test: 'right' },
                                image: product.image,
                                imageAlign: 'right',
                                text: product.text
                            }
                        ]
                    }
                }
            ]
        };
    });
};
