module.exports = function (bh) {
    bh.match('offices', function (ctx) {
        ctx
            .js({
                control: 'radio-button'
            })
            .tag('section');
    });

    bh.match('offices__controls', function (ctx) {
        var selectedCountry = ctx.param('selectedCountry');
        var countries = ctx.param('countries');

        ctx.content({
            block: 'radio-button',
            mods: { size: 'm', theme: 'normal' },
            name: 'country',
            value: selectedCountry,
            content: Object.keys(countries).map(function (countryName) {
                return {
                    elem: 'radio',
                    controlAttrs: {
                        value: countryName
                    },
                    content: countries[countryName]
                };
            })
        });
    });
};
