BEM.DOM.decl('owl-carousel', {
    onSetMod: {
        js: {
            inited: function () {
                this._initCarousel();

                var options = this.params.options || {};

                if (!options.loop) {
                    this._hideArrows();
                }
            }
        }
    },

    _hideArrows: function () {
        this._prev = this.findBlockInside('owl-prev');
        this._next = this.findBlockInside('owl-next');
        this._items = this.findBlocksInside('owl-item');

        this._prev.setMod('disabled', 'yes');

        if (this._areAllItemsActive()) {
            this._next.setMod('disabled', 'yes');
        }

        this.bindTo(this._prev.domElem, 'click', this._handlePrev.bind(this));
        this.bindTo(this._next.domElem, 'click', this._handleNext.bind(this));
    },

    _areAllItemsActive: function () {
        return this._items.every(function (item) {
            return item.domElem.hasClass('active');
        });
    },

    _handlePrev: function () {
        this._next.delMod('disabled');

        if (this._items[0].domElem.hasClass('active')) {
            this._prev.setMod('disabled', 'yes');
        } else {
            this._prev.delMod('disabled');
        }
    },

    _handleNext: function () {
        this._prev.delMod('disabled');

        if (this._items[this._items.length - 1].domElem.hasClass('active')) {
            this._next.setMod('disabled', 'yes');
        } else {
            this._next.delMod('disabled');
        }
    }
});
