module.exports = function (bh) {
    bh.match('partners-info_page_news', function (ctx, json) {
        var filtersLayout = bh.lib.global.isTouch ? 'content' : 'auto';

        ctx.content({
            elem: 'filters',
            content: {
                block: 'news-selects-filters',
                mods: { layout: filtersLayout },
                data: json.data
            }
        });
    });

    bh.match('partners-info__group', function (ctx) {
        var posts = ctx.param('posts');

        var groupsContent = [
            {
                elem: 'column',
                content: []
            },
            {
                elem: 'column',
                content: []
            },
            {
                elem: 'column',
                content: []
            }
        ];

        posts.forEach(function (post, index) {
            var view = post.viewType.split('-');
            var columnNum = index % 3;
            var item = {
                elem: 'list-item',
                content: {
                    block: 'news-item',
                    mods: { view: view[0], size: view[1] || false },
                    post: post
                }
            };

            groupsContent[columnNum].content.push(item);
        });

        ctx.content(groupsContent);
    });
};
