BEM.DOM.decl('product-cta', {
    onSetMod: {
        js: {
            inited: function () {
                this._cta = this.params.cta;

                this._mainMenu = this.findBlockOutside('b-page').findBlockInside('main-menu');

                if (!this._mainMenu) {
                    return;
                }

                var ctaButton = BH.apply({
                    block: 'button2',
                    mods: { size: 'm', theme: 'action', type: 'link', name: 'cta', hidden: 'yes' },
                    url: this._cta.url,
                    text: this._cta.text
                });

                BEM.DOM.append(this._mainMenu.findElem('cta'), ctaButton);

                this._ctaButton = this._mainMenu.findBlockInside({
                    block: 'button2',
                    modName: 'name',
                    modVal: 'cta'
                });

                this._button = this.findBlockInside('button2');

                this._button.bindToWin('scroll', this._onScrollWindow.bind(this));
            }
        }
    },

    _onScrollWindow: function () {
        var menuTopOffset = this._mainMenu.domElem.offset().top;
        var menuHeight = this._mainMenu.domElem.height();
        var bottomMenuOffset = menuTopOffset + menuHeight;

        var buttonTopOffset = this._button.domElem.offset().top;
        var buttonHeight = this._button.domElem.height();
        var bottomButtonOffset = buttonTopOffset + buttonHeight;

        this._ctaButton.toggleMod('hidden', '', 'yes', bottomButtonOffset < bottomMenuOffset);
    }
});
