module.exports = function (bh) {
    bh.match('product-download-file__content', function (ctx, json) {
        ctx
            .content([
                {
                    elem: 'text-content',
                    title: json.title,
                    text: json.text,
                    cta: json.cta
                },
                json.image && {
                    elem: 'image-wrapper',
                    image: json.image
                }
            ]);
    });

    bh.match('product-download-file__text-content', function (ctx, json) {
        ctx
            .content([
                json.title && {
                    elem: 'title',
                    tag: 'h2',
                    content: json.title
                },
                json.text && {
                    elem: 'text',
                    mix: {
                        block: 'html-content'
                    },
                    content: json.text
                },
                json.cta && json.cta.url && {
                    elem: 'button',
                    cta: json.cta
                }
            ]);
    });
};
