module.exports = function (bh) {
    bh.match('product-formats2__content', function (ctx, json) {
        var text = json.text;
        var isDynamicText = ctx.tParam('type') === 'dynamic-text';
        var content = [
            text && {
                elem: 'text',
                mix: {
                    block: 'html-content'
                },
                content: text
            },
            {
                elem: 'formats',
                formats: json.formats,
                isDynamicText: isDynamicText
            }
        ];

        ctx.content(isDynamicText ? content : content.reverse());
    });
};
