module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./backendAnswers.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%;' },
                    mods: { test: 'cards' },
                    content: [
                        {
                            block: 'product-links',
                            data: data.cards.oneItems
                        },
                        {
                            block: 'product-links',
                            data: data.cards.twoItems
                        },
                        {
                            block: 'product-links',
                            data: data.cards.threeItems
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%;' },
                    mods: { test: 'columns' },
                    content: [
                        {
                            block: 'product-links',
                            data: data.columns.oneItems
                        },
                        {
                            block: 'product-links',
                            data: data.columns.twoItems
                        },
                        {
                            block: 'product-links',
                            data: data.columns.threeItems
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%;' },
                    mods: { test: 'columns-2' },
                    content: [
                        {
                            block: 'product-links',
                            data: data['columns-2'].oneItems
                        },
                        {
                            block: 'product-links',
                            data: data['columns-2'].twoItems
                        },
                        {
                            block: 'product-links',
                            data: data['columns-2'].threeItems
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%;' },
                    mods: { test: 'short-title' },
                    content: [
                        {
                            block: 'product-links',
                            data: data.shortTitle.oneItems
                        },
                        {
                            block: 'product-links',
                            data: data.shortTitle.twoItems
                        },
                        {
                            block: 'product-links',
                            data: data.shortTitle.threeItems
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%;' },
                    mods: { test: 'long-text' },
                    content: [
                        {
                            block: 'product-links',
                            data: data.longText
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%;' },
                    mods: { test: 'clear' },
                    content: [
                        {
                            block: 'product-links',
                            data: data.clear
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%;' },
                    mods: { test: 'justify' },
                    content: [
                        {
                            block: 'product-links',
                            data: data.justify
                        }
                    ]
                }
            ]
        };
    });
};
