module.exports = function (bh) {
    bh.match('product-media-cards__items', function (ctx, json) {
        ctx.content(json.items);
    });

    bh.match('product-media-cards__card', function (ctx, json) {
        var data = json.data;

        ctx
            .mods({ 'full-width': data.fullWidth && 'yes' })
            .content({
                elem: 'card-text',
                text: data.text
            });
    });

    bh.match('product-media-cards__card-link', function (ctx, json) {
        var text = json.text || bh.lib.i18n('products', 'more.button');

        ctx.content(json.url && {
            block: 'link',
            mods: { theme: 'normal', size: 's' },
            content: [
                {
                    block: 'product-media-cards',
                    elem: 'card-link-text',
                    content: text
                },
                {
                    block: 'product-media-cards',
                    elem: 'card-link-icon'
                }
            ]
        });
    });
};
