module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./backendAnswers.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'gemini-resizer',
                    mods: { test: 'plain' },
                    content: [
                        {
                            block: 'product-platforms',
                            data: data.oneImage
                        },
                        {
                            block: 'product-platforms',
                            data: data.twoImages
                        },
                        {
                            block: 'product-platforms',
                            data: data.threeImages
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    mods: { test: 'grey' },
                    content: {
                        block: 'product-platforms',
                        data: data.grey
                    }
                },
                {
                    block: 'gemini-resizer',
                    mods: { test: 'grey-new' },
                    content: {
                        block: 'product-platforms',
                        data: data['grey-new']
                    }
                }
            ]
        };
    });
};
