module.exports = function (blocks, blockName) {
    'use strict';
    blocks.declare(blockName, function () {
        var data = require('./backendAnswers.json');

        return {
            block: blockName,
            content: [
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%; height: 706px;' },
                    mods: { test: 'cards' },
                    content: [
                        {
                            block: 'product-toggle-tabs',
                            data: data.cards.oneItems
                        },
                        {
                            block: 'product-toggle-tabs',
                            data: data.cards.twoItems
                        },
                        {
                            block: 'product-toggle-tabs',
                            data: data.cards.threeItems
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%; height: 1272px;' },
                    mods: { test: 'columns' },
                    content: [
                        {
                            block: 'product-toggle-tabs',
                            data: data.columns.oneItems
                        },
                        {
                            block: 'product-toggle-tabs',
                            data: data.columns.twoItems
                        },
                        {
                            block: 'product-toggle-tabs',
                            data: data.columns.threeItems
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%; height: 450px;' },
                    mods: { test: 'short-title' },
                    content: [
                        {
                            block: 'product-toggle-tabs',
                            data: data.shortTitle.oneItems
                        },
                        {
                            block: 'product-toggle-tabs',
                            data: data.shortTitle.twoItems
                        },
                        {
                            block: 'product-toggle-tabs',
                            data: data.shortTitle.threeItems
                        }
                    ]
                },
                {
                    block: 'gemini-resizer',
                    attrs: { style: 'width: 100%; height: 123px;' },
                    mods: { test: 'long-text' },
                    content: [
                        {
                            block: 'product-toggle-tabs',
                            data: data.longText
                        }
                    ]
                }
            ]
        };
    });
};
