module.exports = function (bh) {
    bh.match('search-result__switchers', function (ctx, json) {
        var page = json.page;

        ctx
            .mods({ reversed: !page })
            .content([page && 'left', 'right'].map(function (switcher) {
                if (!switcher) {
                    return '';
                }

                var switcherKey = bh.lib.util.placeholder('switch.{s}', switcher);

                return {
                    elem: 'switch',
                    mods: { type: switcher },
                    content: bh.lib.i18n('search', switcherKey)
                };
            }));
    });
};
