BEM.DOM.decl('search-result', {

    /**
     * Переключение страниц по ALt + ⇆
     * @private
     */
    _bindPages: function () {
        this.__base.apply(this, arguments);

        var bottomWizard = this.findBlockInside('b-bottom-wizard');

        this._page = parseInt(this.params.page, 10) || 0;

        this.bindToDoc('keydown', this._onKeyDown.bind(this));

        if (bottomWizard) {
            BEM.DOM.append(bottomWizard.domElem, BH.apply({
                block: 'search-result',
                elem: 'switchers',
                page: this._page
            }));
        }
    },

    /**
     * Обработчик нажатия клавиши
     * @param {Object} e
     * @private
     */
    _onKeyDown: function (e) {
        if (!e.altKey) {
            return;
        }

        switch (e.keyCode) {
            case BEM.blocks.keycodes.RIGHT:
                this._changePage(this._page + 1);
                break;
            case BEM.blocks.keycodes.LEFT:
                this._changePage(this._page - 1);
                break;
        }
    }
});
