module.exports = function (bh) {
    bh.match('top-menu', function (ctx) {
        ctx.tag('nav');
    });

    bh.match('top-menu__item', function (ctx) {
        var item = ctx.param('item');
        var content = item.url ? {
            elem: 'link',
            url: item.url,
            name: item.name
        } : [
            {
                elem: 'text',
                item: item
            },
            {
                elem: 'submenu',
                subitems: item.items
            }
        ];

        ctx
            .mod('current', ctx.param('current'))
            .content(content);
    });

    bh.match('top-menu__link', function (ctx) {
        ctx
            .tag('a')
            .attr('href', ctx.param('url'))
            .content(ctx.param('name'));
    });

    bh.match('top-menu__text', function (ctx) {
        var item = ctx.param('item');

        ctx.content(item.name);
    });

    bh.match('top-menu__submenu', function (ctx) {
        var subitems = ctx.param('subitems');

        ctx
            .tag('ul')
            .content(subitems.map(function (subitem) {
                return {
                    elem: 'subitem',
                    subitem: subitem
                };
            }));
    });

    bh.match('top-menu__subitem', function (ctx) {
        var subitem = ctx.param('subitem');

        ctx
            .tag('li')
            .content({
                block: 'link',
                mods: { theme: 'top-menu' },
                mix: { block: 'top-menu', elem: 'sublink' },
                url: subitem.url,
                text: subitem.name
            });
    });
};
