const Promise = require('bluebird');
const Gemini = require('gemini/api');
const path = require('path');

const getS3GeminiFolder = require('./s3-folder');
const s3Config = require('./s3-config');

const platforms = ['desktop', 'touch-phone'];

module.exports = (function runner() {
    'use strict';
    Promise
        .each(platforms, platform => {
            console.log(`start testing ${platform}`);

            const isCI = process.env.TEST_ENV === 'ci';

            const url = path.join(s3Config.endpoint, s3Config.bucketName, getS3GeminiFolder('cases', isCI, platform));

            const config = require(`./.gemini.${platform}.json`);

            config.system.projectRoot = `${__dirname}/`;
            config.rootUrl = url;

            return new Gemini(config)
                .test(
                    [`${__dirname}/${platform}.gemini/common/_common.gemini.js`],
                    { reporters: ['html', 'flat'] }
                )
                .then(result => {
                    if (result.failed > 0 || result.errored > 0) {
                        return Promise.reject(2);
                    }
                    return 0;
                })
                .catch(err => exit(err));
        });

    function exit(code) {
        console.log('gemini test failed');
        process.exit(code);
    }
})();
