const path = require('path');
const Promise = require('bluebird');
const assert = require('assert');

const Upload = require('./s3-upload');
const getS3GeminiFolder = require('./s3-folder');
const s3Config = require('./s3-config');

const platforms = ['desktop', 'touch-phone'];


module.exports = (function uploader() {
    const isCredentialsExist = Boolean(s3Config.accessKeyId && s3Config.secretAccessKey);
    assert(isCredentialsExist, 'you have not credentials for access to s3');

    const isCI = process.env.TEST_ENV === 'ci';

    Promise.each(platforms, platform => {
        const publish = Upload(s3Config);

        const folder = `${__dirname}/${platform}.gemini/`;
        const dist = getS3GeminiFolder('cases', isCI, platform);

        const urlBuilder = (folder, file) => path.join(dist, file);

        return publish(folder, urlBuilder)
            .then(() => {
                console.log(`uploading ${platform} has finished`);
            })
            .catch(error => {
                console.error(`uploading ${platform} error:`, error);
            });
    })
})();
