/* eslint-disable no-console */
const path = require('path');
const assert = require('assert');

const Upload = require('./s3-upload');
const getS3GeminiFolder = require('./s3-folder');
const s3Config = require('./s3-config');

module.exports = (function runner() {
    const isCredentialsExist = Boolean(s3Config.accessKeyId && s3Config.secretAccessKey);
    assert(isCredentialsExist, 'you have not credentials for access to s3');

    const isCI = process.env.TEST_ENV === 'ci';

    if(!isCI){
        console.log('dont upload report while local testing');
       return;
    }

    const publish = Upload(s3Config);

    const folder = `${__dirname}/../gemini-report/`;

    const dist = getS3GeminiFolder('report', isCI);

    const urlBuilder = (folder, file) => path.join(dist, file);

    publish(folder, urlBuilder)
        .then(() => {
            console.info('******************************************************************');
            console.info('Report uploaded to S3: ', path.join(s3Config.endpoint, s3Config.bucketName, dist, 'index.html'));
            console.info('******************************************************************');
        })
        .catch(error => {
            console.error('Report uploading error ', error);
        });
})();
