module.exports = function (bh) {
    bh.lib.util = bh.lib.util || {};

    var patterns = {
        short: {
            en: 'MMM D',
            default: 'D MMM'
        },
        long: {
            en: 'MMMM D',
            default: 'D MMMM'
        },
        full: {
            en: 'MMMM D, YYYY',
            'zh-Hans': 'YYYY年MMM月D日',
            default: 'D MMMM YYYY'
        },
        datetime: {
            en: 'MMMM D, YYYY HH:MM',
            default: 'D MMMM YYYY, HH:MM'
        },
        period: {
            'zh-Hans': 'MMM月YYYY年',
            default: 'MMMM YYYY'
        }
    };

    var getMonthName = function (monthAlias) {
        var monthName = bh.lib.i18n('i-tanker__months', monthAlias);

        if (bh.lib.global.lang !== 'en') {
            return monthName.toLowerCase();
        }

        return monthName;
    };

    var components = {
        D: function (date) {
            return date.getDate();
        },
        MMM: function (date) {
            var monthNum = date.getMonth() + 1;

            return getMonthName('short' + monthNum) || monthNum;
        },
        MMMM: function (date, monthAlias) {
            monthAlias = monthAlias || 'g';
            var monthNum = date.getMonth() + 1;

            return getMonthName(monthAlias + monthNum);
        },
        YYYY: function (date) {
            return date.getFullYear();
        },
        HH: function (date) {
            return ('0' + date.getHours()).slice(-2);
        },
        MM: function (date) {
            return ('0' + date.getMinutes()).slice(-2);
        }
    };

    bh.lib.util.date = {

        /**
         * Возвращает дату в человекопонятном виде по переданному формату
         * Если шаблон не передан, то дата вернется в формате D MMMM YYYY
         * @param {Date|String|Number} date Дата
         * @param {String} format Формат даты
         * @param {String} monthAlias Алиас из танкера для перевода месяца
         * @returns {String}
         */
        humanizeDate: function (date, format, monthAlias) {
            var pattern = this._getPattern(format);

            date = this._createDate(date);

            if (date instanceof Date) {
                return this._formatDate(date, pattern, monthAlias);
            }

            return '';
        },

        _formatDate: function (date, pattern, monthAlias) {
            return pattern.replace(/([\w]+)/g, function (str, formatSym) {
                var replacer = components[formatSym];
                var args = [date];

                if (monthAlias) {
                    args.push(monthAlias);
                }

                return replacer.apply(null, args);
            });
        },

        _createDate: function (date) {
            if (typeof date === 'string' || typeof date === 'number') {
                return new Date(date);
            }

            return date;
        },

        _getPattern: function (format) {
            return patterns[format] ?
                (patterns[format][bh.lib.global.lang] || patterns[format].default) : '';
        }
    };
};
