module.exports = function (bh) {
    bh.lib.util = bh.lib.util || {};

    var errorHandlers = {
        code: '_getCodeReason',
        default: '_getDefaultReason'
    };

    bh.lib.util.errors = {

        /**
         * Возвращает текст ошибки при работе с комментариями
         * @param {String} action Тип ошибки
         * @param {Object} error Объект ошибки
         * @param {Object} errorData Данные для текста ошибки
         * @returns {String}
         */
        getCommentsErrorText: function (action, error, errorData) {
            errorData = errorData || {};
            var internalCode = error && error.responseJSON && error.responseJSON.internalCode;
            var errorCodeText = internalCode ? 'code' : 'default';
            var reason = this[errorHandlers[errorCodeText]](internalCode, errorData);

            return bh.lib.i18n('news', 'comments.' + action + '_error', { reason: reason });
        },

        _getCodeReason: function (internalCode, errorData) {
            return bh.lib.i18n('news', internalCode, errorData);
        },

        _getDefaultReason: function () {
            return bh.lib.i18n('news', 'default_error');
        }
    };
};
