module.exports = function (bh) {
    /* eslint-disable complexity */
    /**
     * Строит ссылку на форму из конструктора форм вида
     * @param {Number} formId
     * @param {Boolean} isIframe
     * @param {Object} params
     * @returns {String}
     */
    bh.lib.util.form = function (formId, isIframe, params) {
        if (!formId || !bh.lib.global.formsUrl) {
            return '';
        }

        var query = Object.assign(bh.lib.global.query, params || {}, {
            iframe: isIframe ? 1 : null
        });

        var queryString = Object
            .keys(query)
            .filter(function (key) {
                return query[key] !== null;
            })
            .map(function (key) {
                return bh.lib.util.placeholder('{s}={s}', key, query[key]);
            })
            .join('&');

        var url = bh.lib.util.placeholder(
            queryString ? '{s}{s}/?{s}' : '{s}{s}',
            bh.lib.global.formsUrl, formId, queryString
        );

        return encodeURI(url);
    };
    /* eslint-enable complexity */
};
