module.exports = function (bh) {
    bh.lib.util = bh.lib.util || {};

    var DATE_REGEXP = /(\d\d)\.(\d\d)\.(\d\d\d\d)/;
    var TIME_REGEXP = /(\d\d):(\d\d):(\d\d)/;

    function _parseDate(dateString) {
        var match = dateString && dateString.match(DATE_REGEXP);
        var month = match && Number(match[2]) - 1;

        return match && {
            year: Number(match[3]),
            month: month,
            date: Number(match[1])
        };
    }

    function _parseTime(timeString) {
        var match = timeString && timeString.match(TIME_REGEXP);

        var hours = match && Number(match[1]);
        var minutes = match && Number(match[2]);
        var seconds = match && Number(match[3]);

        return match && {
            hours: hours,
            minutes: minutes,
            seconds: seconds
        };
    }

    /**
     * Получает объект даты по переданной строке вида ДД.ММ.ГГГГ
     * @param {String} dateString
     * @returns {Date}
     */
    bh.lib.util.getDate = function (dateString) {
        var dateObj = _parseDate(dateString);

        return dateObj && new Date(dateObj.year, dateObj.month, dateObj.date);
    };

    /**
     * Получает объект даты в UTC формате по переданной строоке вида ДД.ММ.ГГ ЧЧ:ММ:СС
     * @param {String} dateTimeString
     * @param {Number} timeZoneOffset смещение часового пояса относительно UTC (в часах)
     * @returns {Date}
     */
    bh.lib.util.getUTCDate = function (dateTimeString, timeZoneOffset) {
        timeZoneOffset = timeZoneOffset || 0;

        var dateTime = dateTimeString.split(' ');
        var dateString = dateTime[0];
        var timeString = dateTime[1];

        var dateObj = _parseDate(dateString);
        var timeObj = _parseTime(timeString);

        return dateObj && timeObj && new Date(
            Date.UTC(
                dateObj.year,
                dateObj.month,
                dateObj.date,
                timeObj.hours - timeZoneOffset,
                timeObj.minutes,
                timeObj.seconds
            )
        );
    };
};
