module.exports = function (bh) {
    /* eslint-disable max-len */

    /**
     * Превращает ссылку на /orig изображение в ссылку на необходимый тамбнэйл
     * @param {string} orig - ссылка на orig (напр. https://avatars.mdst.yandex.net/get-adv/.../orig)
     * @param {string} alias - название необходимого алиаса тамбнэйла (напр. a_logo_m)
     * @returns {string}
     */

    bh.lib.util = bh.lib.util || {};

    bh.lib.util.mds = function (orig, alias) {
        var isOrigString = orig && typeof orig === 'string';
        var isAliasString = alias && typeof alias === 'string';

        if (!isOrigString || !isAliasString) {
            return orig;
        }

        return orig.replace(/(\/(get-adv|get-yablogs)\/\S+\/)orig/, '$1' + alias);
    };
};
