module.exports = function (bh) {

    /**
     * Заменяет последовательности {s} на параметры, которые передаются далее
     * Пример: bh.lib.util.placeholder('{s} {s}{s}', 'Hello', 'World', '!') -> 'Hello World!'
     * @returns {String}
     */
    bh.lib.util.placeholder = function () {
        var args = Array.prototype.slice.call(arguments);
        var string = args.shift();

        return string.replace(/\{s\}/g, function (token) {
            var arg = args.shift();

            return typeof arg === 'number' ? arg : arg || token;
        });
    };
};
