module.exports = function (bh) {

    /**
     * Заменяет html мнемоники на символы юникода
     * @param {String} string
     * @returns {String}
     */
    bh.lib.util.replaceHtmlEntities = function(string) {
        var htmlMappings = bh.lib.global.htmlMappings;

        if (!htmlMappings) {
            return string;
        }
        var regex = new RegExp(Object.keys(htmlMappings).join('|'), 'gi');

        return string && string.replace(regex, function(entity) {
            entity = entity.toLowerCase();

            return htmlMappings[entity];
        });
    };
};
