function parseText(text) {
    var data = text.split('\':\'');

    return data.map(function (item) {
        return item.replace(new RegExp('\'', 'g'), '');
    });
}

function parseFormParams(text) {
    var data = text.split(':');
    var formId = data[0];
    var rawParams = data.slice(1);

    var params = rawParams
        .map(function(item) {
            return item.split('=');
        })
        .reduce(function(acc, val) {
            var paramName = val[0];
            var paramValue = val[1];

            acc[paramName] = paramValue;

            return acc;
        }, {});

    return {
        formId: formId,
        params: params
    };
}

module.exports = function (bh) {
    var handlers = {

        /**
         * {{ form: id : getParam }}
         * @param {String} text
         * @returns {Object}
         */
        form: function (text) {
            var formParams = parseFormParams(text);

            return bh.apply({
                block: 'iframe-form',
                formId: formParams.formId,
                params: formParams.params
            });
        },

        /**
         * {{ pseudolink : text }}
         * @param {String} text
         * @returns {Object}
         */
        pseudolink: function (text) {
            return bh.apply({
                block: 'link',
                mods: {
                    theme: 'pseudo',
                    pseudo: 'yes'
                },
                content: text
            });
        },

        /**
         * {{ author : name : description : url }}
         * @param {String} text
         * @returns {Object}
         */
        author: function (text) {
            var items = parseText(text);

            return bh.apply({
                block: 'news-author',
                data: items
            });
        },

        /**
         * {{ cut : title : text }}
         * @param {String} text
         * @returns {Object}
         */
        cut: function (text) {
            var items = parseText(text);

            return bh.apply({
                block: 'news-info',
                elem: 'cut',
                data: items
            });
        },

        /**
         * {{ button : size : theme : text : url : metrikaGoal }}
         * @param {String} text
         * @returns {Object}
         */
        button: function (text) {
            var items = parseText(text);

            return bh.apply({
                block: 'news-button',
                data: items
            });
        }
    };

    /**
     * Ищет и заменяет плэйсхолдеры в текстах из Бункера
     * Синтаксис плэйсхолдеров: {{type:arg}}
     * @param {String} string
     * @returns {String}
     */
    bh.lib.util.template = function (string) {
        if (!string) {
            return '';
        }

        return string.replace(/{{(\w+)(?::(.+?))?}}/g, function (str, type, arg) {
            if (Object.prototype.hasOwnProperty.call(handlers, type)) {
                return handlers[type](arg) || '';
            }

            return str;
        });
    };
};
